SceneManager.snapForBackground = function() {
    this._backgroundBitmap = this.snap();
};

Scene_Load.prototype.onLoadSuccess = function() {
    SoundManager.playLoad();
    this.reloadMapIfUpdated();
    SceneManager.goto(Scene_Map);
    this._loadSuccess = true;
};

Scene_Map.prototype.needsFadeIn = function() {
    return false
};

Window_SavefileList.prototype.drawFileId = function(id, x, y) {
    this.drawText(id + '.', x + 4, y + 2 + 16, 180);
//    this.drawText('  ' + TextManager.file + ' ' + id, x, y, 180);
};


Window_SavefileList.prototype.drawItem = function(index) {
    var id = index + 1;
    var valid = DataManager.isThisGameFile(id);
    var info = DataManager.loadSavefileInfo(id);
    var rect = this.itemRectForText(index);
    this.resetTextColor();
    if (this._mode === 'load') {
        this.changePaintOpacity(valid);
    }
    this.drawFileId(id, rect.x, rect.y);
    if (info) {
        this.changePaintOpacity(valid);
        this.drawContents(info, rect, valid, index);
        this.changePaintOpacity(true);
    }
};



Window_SavefileList.prototype.drawContents = function(info, rect, valid, index) {
		if (Utils.isMobileDevice()) {this.contents.fontSize = 20}
    var bottom = rect.y + rect.height;
    if (rect.width >= 420) {
        this.drawGameTitle(info, rect.x + 44, rect.y + 2 + 16, rect.width - 192, index);
    }
//    if (info.playtime) {
//        this.drawText('New', x, y, width, 'right');
//    }
      this.drawPlaytime(info, rect.x - 4, rect.y + 2 + 16, rect.width);		
};


Window_SavefileList.prototype.drawGameTitle = function(info, x, y, width, index) {
    if (info.title && info.characters) {
		if (info.characters[2] && info.characters[2] != "") {
			var txt = info.characters[2]
		}
		else {
			var txt = info.characters[0] + " [" + info.characters[1] + "]"
		}
		if (index == 0) {txt += " (Autosave)"}
        this.drawText(txt, x, y, width);
    }
};


Game_Party.prototype.charactersForSavefile = function() {
    return this.battleMembers().map(function(actor) {
        return [actor._name];
    });
};

Window_SavefileList.prototype.drawPartyCharacters = function(info, x, y) {
};


DataManager.loadSavefileImages = function(info) {
};


DataManager.maxSavefiles = function() {
	if ($gameTemp.isPlaytest()) {
		return 50
	}
	else {
		return 100
	}
}


DataManager.loadAllSavefileImages = function() {
	return
};




Scene_File.prototype.createListWindow = function() {
    var x = 62
    var y = 28
    var width = 692
    var height = 448
//    var x = 0;
//    var y = this._helpWindow.height;
//    var width = Graphics.boxWidth;
//    var height = Graphics.boxHeight - y;
    this._listWindow = new Window_SavefileList(x, y, width, height);
    this._listWindow.setHandler('ok',     this.onSavefileOk.bind(this));
    this._listWindow.setHandler('cancel', this.popScene.bind(this));
    this._listWindow.select(this.firstSavefileIndex());
//    this._listWindow.setTopRow(0);
    this._listWindow.setTopRow(this.firstSavefileIndex() - 3);
    this._listWindow.setMode(this.mode());
    this._listWindow.refresh();
    this.addWindow(this._listWindow);
};

Window_SavefileList.prototype.maxVisibleItems = function() {
    return 6;
//    return 14;
};

var nk_Scene_File_update = Scene_File.prototype.update
Scene_File.prototype.update = function() {
	nk_Scene_File_update.call(this)
	if (ConfigManager.touchbuttons && this._listWindow && this.sprite) {
		var topRow = this._listWindow.topRow();
		var maxTopRow = this._listWindow.maxTopRow();
		if (maxTopRow > 0 && topRow < maxTopRow && topRow > 0) {
			this.sprite.visible = true
			this.spriteU.visible = false
			this.spriteD.visible = false
		}
		else if (topRow > 0) {
			this.sprite.visible = false
			this.spriteU.visible = true
			this.spriteD.visible = false
		}
		else if (maxTopRow > 0 && topRow < maxTopRow) {
			this.sprite.visible = false
			this.spriteU.visible = false
			this.spriteD.visible = true
		}
	}
}


Scene_File.prototype.create = function() {
	TouchInput.clear();
	
	
	
    Scene_MenuBase.prototype.create.call(this);
    DataManager.loadAllSavefileImages();
//    this.createHelpWindow();
    this.createListWindow();
		
		if (ConfigManager.touchbuttons) {
			this.sprite = new Sprite(ImageManager.loadPicture('zBtnPrevNext'))
			this.sprite.visible = false
			this.addChild(this.sprite)
			
			this.spriteU = new Sprite(ImageManager.loadPicture('zBtnPrevNextU'))
			this.spriteU.visible = false
			this.addChild(this.spriteU)
			
			this.spriteD = new Sprite(ImageManager.loadPicture('zBtnPrevNextD'))
			this.spriteD.visible = false
			this.addChild(this.spriteD)

			this.spriteBack = new Sprite(ImageManager.loadPicture('zBtnBack'))
			this.spriteBack.x = -ConfigManager.movebtn //move x
			this.addChild(this.spriteBack)

		}
		this.createHelpWindow();
};

var alias_afterload_switch = Game_System.prototype.onAfterLoad
Game_System.prototype.onAfterLoad = function() {
	$gameSwitches.setValue(39, true);
	alias_afterload_switch.call(this)
};



Scene_Save.prototype.onSavefileOk = function() {
    Scene_File.prototype.onSavefileOk.call(this);
	$gameVariables.setValue(32, this._listWindow._index)

	if ((Input.isPressed('right') || Input.isPressed('left')) && this._listWindow._index != 0) {
		if (ConfigManager.touchbuttons) {
			$gameScreen.showPicture(456, "zBtnBack", 0, 0, 0, 100, 100, 255, 0);
		}
		else {
			$gameScreen.erasePicture(456);
		}
		SoundManager.playOk()
		SceneManager.push(Scene_Name);
		SceneManager.prepareNextScene(20, 16);
	}
	else {
		//this always runs whether short touch or after inputting 20's name

		if (($gameActors.actor(19)._name != "" && s(34)) || s(157)) {
			$gameActors.actor(20).setName($gameActors.actor(19)._name)
		}
		else if (!$gameSwitches.value(34)) { //default
			$gameActors.actor(20).setName("")
		}

		
		$gameSystem.onBeforeSave();
		if (this.savefileId() == 1) {
			this.onSaveFailure();
		}
		else if (DataManager.saveGame(this.savefileId())) {
			vset(231,Graphics.frameCount)
			this.onSaveSuccess();
		} else {
			this.onSaveFailure();
		}
	}
};


var NK_Savegame = Game_Interpreter.prototype.pluginCommand;
Game_Interpreter.prototype.pluginCommand = function(command, args) {
	NK_Savegame.call(this, command, args);
	if (command.toLowerCase() === "save") {
		var id = 1
		if (args[0]) {id = args[0]}
		vset(231,Graphics.frameCount)
		$gameSystem.onBeforeSave();
		DataManager.saveGame(id);
		if (pic(463)) {
			$gameScreen.movePicture(463, 0, pic(463)._x, pic(463)._y, 100, 100, 255, 0, 1);
		}
	}
	if (command.toLowerCase() === "nudify") {
		if (args[0]) {nudify(args[0])}
		else {nudify()}
	}
}

var NK_Scene_Map_update_loadmsg = Scene_Map.prototype.update;
Scene_Map.prototype.update = function() {
	NK_Scene_Map_update_loadmsg.call(this)
	if (pic(463)) {
		if (pic(463)._opacity >= 255) {
			six(26,5) //chara creation
			if (tisx(26,5,20)) {
				$gameScreen.movePicture(463, 0, pic(463)._x, pic(463)._y, 100, 100, 0, 0, 30);
				sixset(26,5,0)
			}
		}
	}
}





function Scene_Delete() {
    this.initialize.apply(this, arguments);
}

Scene_Delete.prototype = Object.create(Scene_Load.prototype);
Scene_Delete.prototype.constructor = Scene_Delete;

Scene_Delete.prototype.initialize = function() {
    Scene_Load.prototype.initialize.call(this);
};

Scene_Delete.prototype.mode = function() {
    return 'delete';
};

Scene_Delete.prototype.onSavefileOk = function() {
    Scene_File.prototype.onSavefileOk.call(this);
    if (DataManager.testloadGame(this.savefileId()) &&
	this.savefileId() != 1) {
        this.onLoadSuccess(); //deletes file
    } else {
        this.onLoadFailure();
    }
};



DataManager.testloadGame = function(savefileId) {
    if (this.isThisGameFile(savefileId)) {
        return true;
    } else {
        return false;
    }
};


Scene_Delete.prototype.onLoadSuccess = function() {
    SoundManager.playLoad();
	StorageManager.remove(this.savefileId());
	StorageManager.cleanBackup(this.savefileId());
	this.activateListWindow();
	this._listWindow.refresh();
};

Scene_Delete.prototype.helpWindowText = function() {
	$gameVariables.setValue(33, 2)
    return "Delete which file?";
};



DataManager.saveGameWithoutRescue = function(savefileId) {
    var json = JsonEx.stringify(this.makeSaveContents());
//    if (json.length >= 200000) {
    if (json.length >= 2000000) {
        console.warn('Save data too big!');
    }
    StorageManager.save(savefileId, json);
	if (savefileId != 1) {this._lastAccessedId = savefileId;}
    var globalInfo = this.loadGlobalInfo() || [];
    globalInfo[savefileId] = this.makeSavefileInfo();
    this.saveGlobalInfo(globalInfo);
    return true;
};

DataManager.loadGameWithoutRescue = function(savefileId) {
    var globalInfo = this.loadGlobalInfo();
    if (this.isThisGameFile(savefileId)) {
        var json = StorageManager.load(savefileId);
        this.createGameObjects();
        this.extractSaveContents(JsonEx.parse(json));
		if (savefileId != 1) {this._lastAccessedId = savefileId;}
        return true;
    } else {
        return false;
    }
};

DataManager.latestSavefileId = function() {
    var globalInfo = this.loadGlobalInfo();
    var savefileId = 2;
    var timestamp = 0;
    if (globalInfo) {
        for (var i = 2; i < globalInfo.length; i++) {
            if (this.isThisGameFile(i) && globalInfo[i].timestamp > timestamp) {
                timestamp = globalInfo[i].timestamp;
                savefileId = i;
            }
        }
    }
    return savefileId;
};

Scene_File.prototype.createHelpWindow = function() {
    this._helpWindow = new Window_Help(7);
    this._helpWindow.setText(this.helpWindowText());
    this.addWindow(this._helpWindow);
};

Scene_Save.prototype.helpWindowText = function() {
	$gameVariables.setValue(33, 1)
	if (ConfigManager.alwaysDash) {
		var txt = "Save to which file? (Browsing local files. Quit to title to\n"
		txt += "reset.) You can apply a custom label to your savefile by:\n\n"
	}
	else {
		var txt = "Save to which file? You can apply a custom label to your\n"
		txt += "savefile by:\n\n"
	}

	txt += "Keyboard/ Controller: Hold [←] or [→], then select slot.\n"
	txt += "Mouse/ Android: Click and hold on slot."
	
	return txt
};

Scene_Load.prototype.helpWindowText = function() {
	$gameVariables.setValue(33, 2)
	if (ConfigManager.alwaysDash) {
		return "Load which file? (Browsing local files. Quit to title to\nreset.)"
	}
	else {
		return "Load which file?"
	}
};


DataManager.selectSavefileForNewGame = function() {
    this._lastAccessedId = 2;
};